# - Config file for rocprofiler-sdk-rocattach and its component libraries
# It defines the following variables:
#
# rocprofiler-sdk-rocattach_VERSION
# rocprofiler-sdk-rocattach_INCLUDE_DIR
# rocprofiler-sdk-rocattach_LIB_DIR
# rocprofiler-sdk-rocattach_LIBRARIES
#
# It provides the following interface libraries:
#
# rocprofiler-sdk-rocattach::rocprofiler-sdk-rocattach
#

# prevent "target already exists" error
include_guard(DIRECTORY)

# compute paths
get_filename_component(rocprofiler-sdk-rocattach_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocprofiler-sdk-rocattach_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocprofiler-sdk-rocattach_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
get_filename_component(rocprofiler-sdk-rocattach_ROOT_DIR ${rocprofiler-sdk-rocattach_INCLUDE_DIR} PATH)
set_and_check(rocprofiler-sdk-rocattach_ROOT "${rocprofiler-sdk-rocattach_ROOT_DIR}")

# extra validation
foreach(_rocprofiler-sdk-rocattach_SUBDIR include/rocprofiler-sdk-rocattach)
    set_and_check(_rocprofiler-sdk-rocattach_SUBDIR_CHECK
                  "${PACKAGE_PREFIX_DIR}/${_rocprofiler-sdk-rocattach_SUBDIR}")
    unset(_rocprofiler-sdk-rocattach_SUBDIR_CHECK)
endforeach()

set(rocprofiler-sdk-rocattach_LIBRARIES)

# add interface library
add_library(rocprofiler-sdk-rocattach::rocprofiler-sdk-rocattach INTERFACE IMPORTED)

if(rocprofiler-sdk-rocattach_BUILD_TREE
   AND EXISTS "${CMAKE_CURRENT_LIST_DIR}/rocprofiler-sdk-rocattach-build-config.cmake")
    include("${CMAKE_CURRENT_LIST_DIR}/rocprofiler-sdk-rocattach-build-config.cmake")
else()
    include("${rocprofiler-sdk-rocattach_CMAKE_DIR}/rocprofiler-sdk-rocattach-targets.cmake")

    # Library dependencies
    if(rocprofiler-sdk-rocattach_FIND_COMPONENTS)
        foreach(COMP ${rocprofiler-sdk-rocattach_FIND_COMPONENTS})
            set(TARG rocprofiler-sdk-rocattach::rocprofiler-sdk-rocattach-${COMP})
            if(TARGET ${TARG})
                set(rocprofiler-sdk-rocattach_${COMP}_FOUND 1)
                list(APPEND rocprofiler-sdk-rocattach_LIBRARIES ${TARG})
                target_link_libraries(rocprofiler-sdk-rocattach::rocprofiler-sdk-rocattach INTERFACE ${TARG})
            else()
                set(rocprofiler-sdk-rocattach_${COMP}_FOUND 0)
            endif()
        endforeach()
    else()
        foreach(TARG rocprofiler-sdk-rocattach-shared-library)
            set(TARG rocprofiler-sdk-rocattach::${TARG})
            list(APPEND rocprofiler-sdk-rocattach_LIBRARIES ${TARG})
            target_link_libraries(rocprofiler-sdk-rocattach::rocprofiler-sdk-rocattach INTERFACE ${TARG})
        endforeach()
    endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocprofiler-sdk-rocattach
    FOUND_VAR rocprofiler-sdk-rocattach_FOUND
    VERSION_VAR rocprofiler-sdk-rocattach_VERSION
    REQUIRED_VARS rocprofiler-sdk-rocattach_ROOT_DIR rocprofiler-sdk-rocattach_INCLUDE_DIR
                  rocprofiler-sdk-rocattach_LIB_DIR rocprofiler-sdk-rocattach_LIBRARIES rocprofiler-sdk-rocattach_VERSION
    HANDLE_COMPONENTS HANDLE_VERSION_RANGE)
