local help_message = [[

ROCm Compute Profiler is an open-source performance analysis tool for profiling
machine learning/HPC workloads running on AMD MI GPUs.

Version 3.4.0
]]

help(help_message,"\n")

whatis("Name: rocprofiler-compute")
whatis("Version: 3.4.0")
whatis("Keywords: Profiling, Performance, GPU")
whatis("Description: tool for GPU performance profiling")
whatis("URL: https://github.com/ROCm/rocm-systems/tree/develop/projects/rocprofiler-compute")

-- Export environmental variables
local topDir="/__w/TheRock/TheRock/build/profiler/rocprofiler-compute/stage"
local binDir="/__w/TheRock/TheRock/build/profiler/rocprofiler-compute/stage/bin"
local shareDir="/__w/TheRock/TheRock/build/profiler/rocprofiler-compute/stage/share"
local pythonDeps=""

setenv("ROCPROFCOMPUTE_DIR",topDir)
setenv("ROCPROFCOMPUTE_BIN",binDir)
setenv("ROCPROFCOMPUTE_SHARE",shareDir)

-- Update relevant PATH variables
prepend_path("PATH",binDir)
if ( pythonDeps  ~= "" ) then
   prepend_path("PYTHONPATH",pythonDeps)
end
