##############################################################################
# MIT License
#
# Copyright (c) 2025 Advanced Micro Devices, Inc. All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

##############################################################################
"""
Panel Widget Modules
-------------------
Contains the panel widgets used in the main layout.
"""

from textual.app import ComposeResult
from textual.containers import Vertical
from textual.widgets import TabPane

from rocprof_compute_tui.views.kernel_view import KernelView
from rocprof_compute_tui.widgets.tabbed_content import TabsTabbedContent


class CenterPanel(Vertical):
    """
    The response area.
    """

    COMPONENT_CLASSES = {
        "border-title-status",
    }

    def __init__(self) -> None:
        super().__init__()

        self.default_tab = "center-analyze"
        self.kernel_view = KernelView()

    def compose(self) -> ComposeResult:
        with TabsTabbedContent(initial="tab-kernel"):
            with TabPane("Basic View", id="tab-kernel"):
                yield self.kernel_view

    def on_mount(self) -> None:
        self.add_class("section")
