// Copyright (c) 2022-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_RADIX_SORT_BLOCK_SORT_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_RADIX_SORT_BLOCK_SORT_HPP_

#include "../../../config.hpp"
#include "../../../type_traits.hpp"
#include "../../config_types.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{
template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 25};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 25};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 28};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{128, 13};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 15};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 18};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 25};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 28};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 28};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 28};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 30};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 23};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 31};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 26};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 24};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 27};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 29};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 32};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 24};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 29};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 31};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna4, target_arch::gfx1201, gpu::rx9070, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 22};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 25};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 22};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{128, 25};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 25};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 26};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 27};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 29};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 22};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 28};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 25};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 30};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 29};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 25};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{128, 29};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 29};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 32};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{128, 30};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 27};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 31};
    }
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{64, 16};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{128, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{64, 17};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{64, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{64, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 16};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{64, 16};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{64, 16};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 7};
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 13};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 18};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 14};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 23};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 19};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 22};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 6};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 7};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 11};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 11};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 19};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 23};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 14};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 19};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 23};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 13};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 17};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 22};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 7};
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 11};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 11};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 30};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{1024, 15};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 29};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 31};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{512, 4};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 28};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{1024, 18};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 27};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{1024, 22};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 7};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 11};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 11};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 14};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 31};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{512, 30};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 29};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 31};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{512, 4};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 12};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 30};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{1024, 18};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{1024, 16};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{1024, 22};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 13};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 30};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{1024, 16};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{1024, 15};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{1024, 23};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 14};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{512, 18};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 32};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 15};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 4};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 23};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 27};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{512, 4};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 5};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 30};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 23};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 29};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>>::value,
    kernel_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = double, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = float, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 32};
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{512, 8};
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{512, 14};
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{512, 18};
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 14};
    }
    // Based on key_type = rocprim::half, value_type = empty_type
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 21};
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 5};
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 5};
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 5};
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 5};
    }
    // Based on key_type = rocprim::int128_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int64_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 10};
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 19};
    }
    // Based on key_type = int, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{256, 8};
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{256, 16};
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 29};
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{512, 18};
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 15};
    }
    // Based on key_type = short, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 22};
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return kernel_config_params{512, 7};
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return kernel_config_params{1024, 4};
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return kernel_config_params{256, 21};
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)
                  && (!std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{256, 23};
    }
    // Based on key_type = int8_t, value_type = empty_type
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (std::is_same<value_type, rocprim::empty_type>::value)))
    {
        return kernel_config_params{512, 21};
    }
    // Default case if none of the conditions match
    return radix_sort_block_sort_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto radix_sort_block_sort_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>::value,
    kernel_config_params>
{
    return radix_sort_block_sort_config_picker<
        comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
        key_type,
        value_type>();
}

// All the existing configs should be auto generated
using radix_sort_block_sort_targets
    = comp_targets<comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>,
                   comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>,
                   comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>,
                   comp_target<gen::rdna4, target_arch::gfx1201, gpu::rx9070, rep::amdgcn>,
                   comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>,
                   comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
                   comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>,
                   comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>,
                   comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>;

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_RADIX_SORT_BLOCK_SORT_HPP_
