//===----------------------------------------------------------------------===//
//
// Part of the libcu++ Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// Modifications Copyright (c) 2024-2025 Advanced Micro Devices, Inc.
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// UNSUPPORTED: hipcc, hiprtc
// UNSUPPORTED: nvrtc, pre-sm-70

// uncomment for a really verbose output detailing what test steps are being launched
#define DEBUG_TESTERS

#include <cuda/std/cassert>
#include <cuda/std/semaphore>

#include "helpers.h"

template <int N>
struct release
{
  static constexpr size_t threadcount = N;

  template <typename Semaphore>
  __host__ __device__ static void perform(Semaphore& semaphore)
  {
    semaphore.release(1);
  }
};

template <int N>
struct acquire
{
  static constexpr size_t threadcount = N;

  template <typename Semaphore>
  __host__ __device__ static void perform(Semaphore& semaphore)
  {
    semaphore.acquire();
  }
};

using a3_r3_a3_r3 = performer_list<acquire<3>, release<3>, acquire<3>, release<3>>;

void kernel_invoker()
{
  validate_pinned<cuda::std::counting_semaphore<3>, a3_r3_a3_r3>(3);
  validate_pinned<cuda::counting_semaphore<cuda::thread_scope_system, 3>, a3_r3_a3_r3>(3);
}

int main(int arg, char** argv)
{
  NV_IF_TARGET(NV_IS_HOST, (kernel_invoker();))

  return 0;
}
