/*******************************************************************************
 *
 * MIT License
 *
 * Copyright 2021-2025 AMD ROCm(TM) Software
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/

#pragma once

#include <rocRoller/Expression.hpp>

namespace rocRoller
{
    namespace BufferDescriptor
    {
        Expression::ExpressionPtr SetDefaults(Expression::ExpressionPtr bufferExpr, ContextPtr ctx);
        Expression::ExpressionPtr GetDefaultOptions(ContextPtr ctx);
        Expression::ExpressionPtr SetBasePointer(Expression::ExpressionPtr bufferExpr,
                                                 Expression::ExpressionPtr ptrExpr);
        Expression::ExpressionPtr GetBasePointer(Expression::ExpressionPtr bufferExpr);
        Expression::ExpressionPtr IncrementBasePointer(Expression::ExpressionPtr bufferExpr,
                                                       Expression::ExpressionPtr offsetExpr);
        Expression::ExpressionPtr SetSize(Expression::ExpressionPtr bufferExpr,
                                          Expression::ExpressionPtr sizeExpr);
        Expression::ExpressionPtr GetSize(Expression::ExpressionPtr bufferExpr);
        Expression::ExpressionPtr SetOptions(Expression::ExpressionPtr bufferExpr,
                                             Expression::ExpressionPtr optsExpr);
        Expression::ExpressionPtr GetOptions(Expression::ExpressionPtr bufferExpr);
    }
}
